function crray = dcpread( chr, uchr, reg, spos, epos, strn, ustrn, rlen, mut, zs)
% compute variables for mixture models (r_{t,j},g_t, so on)
dmut = false(rlen,1);
dloc = (spos:epos)';
drlen = rlen .* ones(rlen,1,'int8');
dchr = int8(find(uchr == chr,1,'first')) .* ones(rlen,1,'int8');
dreg = reg .* ones(rlen,1,'int32');
dstrn = logical((ustrn(2) == strn) .* true(rlen,1)); % true .* true = double. wtf!

if (strn == ustrn(2)) % strn = '+'
    dpos = (1:rlen)';
    %     dzs = reshape(cell2mat(zs(2,rlen,:)),rlen,3);
    dzs = cat(1,zs{2,rlen})';
else
    dpos = (rlen:-1:1)';
    %     dzs = reshape(cell2mat(zs(1,rlen,:)),rlen,3);
    dzs = flipud(cat(1,zs{1,rlen})'); % pos fliped. zs should be fliped too.
end

dmut(ismember(dloc,mut),1) = 1;

crray = {dchr, dloc, dmut, dpos, dreg, drlen, dstrn, dzs};

end