function [ am1, am2, at1, at2 ] = equallen( m1, m2, t1, t2 )
% to adjust matrix for consistent lengths

maxlen = max([length(m1{1}),length(m1{2}),length(m2{1}),length(m2{2})]);

am1 = {apenmat(m1{1},maxlen), apenmat(m1{2},maxlen)};
am2 = {apenmat(m2{1},maxlen), apenmat(m2{2},maxlen)};
at1 = apenvec(t1,maxlen);
at2 = apenvec(t2,maxlen);
end

function [ y ] = apenmat( x, maxlen, varargin )
diflen = maxlen - length(x);
if diflen > 0
    y = [x,zeros(length(x),diflen)];
    y = [y;zeros(diflen,maxlen)];
else
    y = x;
end
end

function [ y ] = apenvec( x, maxlen )
diflen = maxlen - length(x);
if diflen > 0
    y = [x;zeros(diflen,2)];
else
    y = x;
end
end