function N = nbh_chk(TRANS, alpha, beta)

MAX_DEV = 1e-6;

% Check input arguments
error(nargchk(3, 3, nargin));
% Check transition matrix
[N, Nc] = size(TRANS);
if (Nc ~= N)
  error('Transition matrix must be square.');
end
if (any(TRANS < 0) | any(TRANS > 1))
  error('Inconsistent number in transition matrix.');
end
trows = size(TRANS,2);
temp = 0;
for k = 2:trows
    temp = temp + sum(diag(TRANS,k) + diag(TRANS,-k));
end
if temp > 0
    error('Transitions are not allowed to remote states.');
end
if (any(abs(sum(TRANS')-ones(1,N)) > MAX_DEV))
  error('Transition matrix is not normalized.');
end
if (length(alpha) ~= N)
  error('Transition matrix and shape parameters must have the compatible sizes.');
end
if (any(alpha) <= 0)
  error('Shape parameters must be positive.');
end
if any(alpha ~= alpha(1))
    error('alpha must be identical for all states.');
end
if (length(beta) ~= N)
  error('Transition matrix and inverse scales must have the compatible sizes.');
end
if (any(beta) <= 0)
  error('Inverse scales must be positive.');
end
 if all(beta(1:(end-1)) ./ beta(2:end) < 1)
        error('the order constraint was violoated.');
 end
