fbgibbs = function(datachr,   c = 3, p = c(0.04, 0.02, 0.3), pi = c(0.5, 0.5, 0),
                   fkab = t(matrix(c(1,-1,0,
                                     1,1,0.05,
                                     1,1,0.05),3,3)),
                   K_T = matrix(c(0.98, 0.02, 0.00,
                                  0.05, 0.92, 0.03,
                                  0.00, 0.99, 0.01),3,3),
                   K_N2 = c(0.05, 0.95, 0.00),
                   phi_T = c(0.90, 0.1, 0.00),
                   epsil = 0.195, delta = 0.005, tot = 10000, burnp = 0.5, 
                   nsv = 1, doppc = FALSE, doprintout = FALSE){

  peak = c + 1;
  
  datachr = filtout(datachr,c,1);
  datachr$torn = ((datachr$nt=='T' & datachr$strand=='+') || (datachr$nt=='T' & datachr$strand=='-' ) );
  datachr$torn[is.na(datachr$torn)] = FALSE;
  
  pub = epsil;
  burn = as.integer(tot*burnp):tot;
  miburn = min(burn);
  burnlen = length(burn);
  
  tposlen = as.matrix(aggregate(datachr$pos, by=list(region = datachr$region_id), length));
  treglen = dim(tposlen)[1];
  tposlen = cbind(tposlen,rep(0,treglen));
  regdv = as.integer((treglen/nsv));
  
  X = datachr$tag;
  peak = min(X);
  c = peak - 1;
  maxx = max(X);
  
  M = datachr$mutant;
  tn = datachr$torn;
  
  regsv = list();
  posv = list();
  
  # slice variables by regions for parallel computing
  for (sv in 1:nsv) {
    if (sv != nsv) {
      regsv[[sv]] = (regdv*(sv-1) + 1):(regdv*sv)
      tposlen[(regdv*(sv-1) + 1):(regdv*sv),3] = sv;    
    }
    else {
      regsv[[sv]] = (regdv*(sv-1) + 1):treglen
      tposlen[(regdv*(sv-1) + 1):treglen,3] = sv;
    }
    if (sv == 1) {
      posv[[sv]] = 1:sum(tposlen[regsv[[sv]],2]);
    }
    else
    {
      posv[[sv]] = (1:sum(tposlen[regsv[[sv]],2])) + max(posv[[sv-1]]);
    }
  }
  
  reglen = as.integer(nsv);
  datalen = as.integer(nsv);
  poslen = list();
  possum = list();
  
  for (sv in 1:nsv) {
    reglen[sv] = sum(tposlen[,3]==sv);
    poslen[[sv]] = tposlen[tposlen[,3]==sv,2];
    possum[[sv]] = c(0,cumsum(poslen[[sv]])[-reglen[[sv]]]);
    datalen[sv] = cumsum(poslen[[sv]])[reglen[[sv]]];
  }
  
  tdatalen = sum(datalen);

  # to track quantities in MCMC chains.
  matT = list();
  matT$t = array(numeric(0),dim=c(tot,3,3));
  matT$nt = array(numeric(0),dim=c(tot,3,3));
  matT$phit = array(numeric(0),dim=c(tot,1,3));
  matT$phint = array(numeric(0),dim=c(tot,1,3));
  matkab = array(numeric(0),dim=c(tot,9));
  matpi = array(numeric(0),dim=c(tot,3));
  matp = array(numeric(0),dim=c(tot,3));
  matlog = numeric(tot);
  matrlike = numeric(tot);
  matIP = matrix(logical(3*tdatalen),3,tdatalen);
  matmom = array(numeric(0),dim=c(tot,3));
  
  # acceptance ratio of the MH sampler
  acc = list();
  acc$kab = matrix(rep(0,9),3,3);
  
  # I: hidden state
  I = rep(as.integer(0),tdatalen);
 
  # z: zero-inflated state indicator
  z = rep(as.logical(0),tdatalen);
  
  #set hyperparameter for transition matrices, initial distributions and theta
  akab = c(0,10^100); # log-scale
  at1 = c(0.01,0.01);
  at2 = list();
  at2$t = c(0.01,0.01,0.01);
  at2$nt =  c(0.01,0.01);
  as = list(t = c(0.01,0.01,0.01) , nt =  c(0.01,0.01));
  at3 = c(0.01,0.01);
  api = c(0.01,0.01);
  ap = c(0.01,0.01);
  
  #create matrix for post-hyperparameters
  papi = matrix(nrow=3,ncol=2);
  pap = matrix(nrow=3,ncol=2);
  pat1 = rep(0,2);
  pat2 = list(t = rep(0,3), nt = rep(0,2));
  pat3 = rep(0,2);
  pas = list(t=rep(0,3),nt=rep(0,2));
  
  fkab[,2] = -fkab[,2];
  fkab[,3] = log(fkab[,3]);
  fkab[1,3] = -10;
  
  kab = bparam(fkab);
  
  T = list();
  T$t = K_T;  
  T$nt = matrix(c(T$t[1,],
                  K_N2,
                  0.00, 1.00, 0.00),3,3);
  phi_N = c(phi_T[-3],0)/sum(phi_T[-3]);
  T$phit = phi_T;
  T$phint = phi_N;

  
  # coveriance matrix for the random walk proposal of read count distribution  
  comat = list();
  comat[[1]] = diag(2);
  comat[[2]] = diag(2);
  icsig = list();
  icsig[[1]] = 0.005^2 * comat[[1]];
  icsig[[2]] = 0.005^2 * comat[[2]];
  csig = lapply(icsig,chol);
  csig = lapply(csig,t);
  
  # likelihoods for the ppc
  replike = 0;
  loglike = 0;
  ppc = 0;
  
  ####################################################################################### 
  # iteration begins
  #######################################################################################
  for (iter in 1:tot){

    # backward sampling and hyperparameter updates using parallelized regions
    bigparl = foreach (sv = 1:nsv) %dopar% {bigpar(poslen[[sv]],datalen[sv],reglen[sv],possum[[sv]],
                                                   lapply(T,log),X[posv[[sv]]],M[posv[[sv]]],tn[posv[[sv]]],
                                                   kab,p,pi,c,iter,miburn);}
    
    # combine parallelized outcomes
    comb = combparl(bigparl,nsv,c);
    I = comb$I;
    ntrans = comb$ntrans;
    nini = comb$nini;
    z = comb$z;
    nI = comb$nI;
    mnI = comb$mnI;
    lI = comb$lI;
    
    #
    # update posteriors by add hyperparameters in prior specifications
    #
    pap = comb$pap + ap;
    papi = comb$papi + api;
    
    # update posterior hyperparameters of transition matrices.
    pat1 = at1 + ntrans$t[1,1:2] + ntrans$nt[1,1:2];
    pat2$t = at2$t + ntrans$t[2,1:3];
    pat2$nt = at2$nt + ntrans$nt[2,1:2];
    pat3 = at3 + ntrans$t[3,2:3];
    pas$t = as$t + nini$t;
    pas$nt = as$nt + nini$nt[1:2];
    
    
    #update transition matrices.
    T = mhT(pat1,pat2,pat3,pas);
    
    #update p
    p = updatep(p,pap,pub,delta);
    
    #update pi
    pi = updatepi(pi,papi);
    
    #update k,a,b     
    lkab = tabupdatekab(kab,akab,X,maxx,c,I,csig);
    kab = lkab$kab;
    
    if (iter >= miburn) {
      if (doppc) {
      rep = cgenrep(tn,tdatalen,c,kab,p,pi,I);
      lrep = foreach(sv = 1:nsv) %dopar% cgenrep(tn[posv[[sv]]],datalen[sv],c,d,q,kab,p,pi,lI[[sv]]);
      rep = list();
      rep$X = foreach(sv = 1:nsv, .combine='c') %do% lrep[[sv]]$X;
      rep$M = foreach(sv = 1:nsv, .combine='c') %do% lrep[[sv]]$M;
      
      replike = cloglike(rep$X,rep$M,tn,kab,p,pi,c,I,tdatalen);    
      loglike = cloglike(X,M,tn,kab,p,pi,c,I,tdatalen);
      }
    }
    
    matT$t[iter,,] = T$t;
    matT$nt[iter,,] = T$nt;
    matT$phit[iter,,] = T$phit;
    matT$phint[iter,,] = T$phint;
    
    matkab[iter,] = c(kab);
    matmom[iter,] = lkab$mom;
    
    matpi[iter,] = pi;
    matp[iter,] = p;
    matlog[iter] = loglike;
    matrlike[iter] = replike;
    
    if (iter >= miburn) {
      acc$kab = acc$kab + lkab$acc;
      matIP = matIP + rbind(I==1,I==2,I==3);
      ppc = ppc + (replike >= loglike);
    }
    
    fkab = fparam(kab);
    
    if (doprintout) {
    print(sprintf('#iter = %d ,#cores = %d', iter, nsv))
    print(sprintf('c = %d, peak = %d, log-like = %.01f,replog = %.01f',c,peak,loglike,replike));   
    print(sprintf("fkab[1,]: %s", paste(round(fkab[1,],digits=2), collapse=",")))
    print(sprintf("fkab[2,]: %s", paste(round(fkab[2,],digits=2), collapse=",")))
    
    print(sprintf("mean: %s", paste(round(lkab$mom,digits=2), collapse=",")))
    print(sprintf('p = %0.3f,%0.3f,%0.3f',p[1],p[2],p[3]));
    print(sprintf('pi = %0.3f,%0.3f,%0.3f',pi[1],pi[2],pi[3]));
    print(sprintf('#I_1 = %d, #I_2 = %d, #I_3 = %d',nI[1],nI[2],nI[3]));    
    print('+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++');   
    }
  }
  
  ###############################################################################
  #end of gibbs interation
  ###############################################################################
  
  matIP = matIP/burnlen;
  for (k in 1:2) {
    acc$kab[[k]] = acc$kab[[k]]/burnlen;
  }
  ppc = ppc /burnlen;
  
  #matz = matz/burnlen;
  sumc = list();  
  mc = list(matkab,matp,matpi,matT,
            matlog,acc,tot,burn,burnlen,sumc,matIP,matrlike,ppc,peak,c,matmom)
  names(mc) = c("kab","p","pi","T",
                "like","acc","tot","burn","burnlen","sumc","IP",
                "rlike","ppc","peak","c","mom")
  Tt = foreach(i = mc$burn, .combine = "+") %do% mc$T$t[i,,]/mc$burnlen;
  Tnt = foreach(i = mc$burn, .combine = "+") %do% mc$T$nt[i,,]/mc$burnlen;
  Tphit = foreach(i = mc$burn, .combine = "+") %do% mc$T$phit[i,,]/mc$burnlen;
  Tphint = foreach(i = mc$burn, .combine = "+") %do% mc$T$phint[i,,]/mc$burnlen;
  
  sumkaball = matrix(apply(mc$kab[mc$burn,],2,mean),3,3);
  sumkaball[,2] = exp(-sumkaball[,2]);
  sumkaball[,3] = exp(sumkaball[,3]);
  sumkaball[1,3] = 0;
  
  mc$sumc[[1]] = list(T = Tt, N = Tnt);
  mc$sumc[[2]] = list(T = Tphit, N = Tphint);                                                                                                         
  mc$sumc[[3]] = sumkaball;
  mc$sumc[[4]] = apply(mc$p[mc$burn,],2,mean);
  mc$sumc[[5]] = apply(mc$pi[mc$burn,],2,mean);
  mc$sumc[[6]] = mean(mc$like[mc$burn]);
  mc$sumc[[7]] = apply((mc$IP[c(1,2,3),]>0.99),1,sum);
  names(mc$sumc) = c("K","phi","bg","p","pi","like","nstates");
  
  for (i in 1:7){
    if (i < 4) {
      for (j in 1:2){
        mc$sumc[[i]][[j]] = round(mc$sumc[[i]][[j]],digits=4);
      }
    } else {
      mc$sumc[[i]] = round(mc$sumc[[i]],digits=4);
    }
  }
  
  return(mc)
}
