#
# backward sampling along with hyperparameter updates.
#
bigpar = function(poslen,datalen,reglen,possum,logTs,X,M,tn,kab,p,pi,c,iter,miburn){
  # compute filtering distributions
  lP = cforwardP(poslen,datalen,reglen,possum,logTs,X,M,tn,c,kab,p,pi);
  
  # backward sampling
  BackS = cbackS(poslen,datalen,reglen,possum,tn,lP);
  
  # compute smoothing distributions
  if (iter >= miburn) {
    #bP = cbackP(poslen,datalen,reglen,possum,tn,lP);
    bP = matrix(numeric(0),3,datalen);
  } else {bP = 0;}
  
  # gen missing data Z|pi,p,I,X,M
  z = genz(datalen,pi,p,BackS$I,X,M);
  
  # assign variables for posterior hyperparameters (papi, pap, palam)
  papi = matrix(nrow=3,ncol=2);
  pap = matrix(nrow=3,ncol=2);
  
  # compute posterior hyperparameters w/o adding priors (papi, pap, palam)
  for (s in 1:3) {
    pap[s,] = c(sum(M[BackS$I==s & tn]), sum(X[BackS$I==s & z == 0 & tn]) - sum(M[BackS$I==s & tn]));
    if ( s < 3 ) papi[s,] = c(sum(z[BackS$I==s & tn]==1),sum(z[BackS$I==s & tn]==0));
  }
  
  # numbers of sites in each state.
  nI = c(sum(BackS$I==1),sum(BackS$I==2),sum(BackS$I==3));
  
  bigparl = list(BackS$I,BackS$ntranst,BackS$ninit,BackS$ntransnt,BackS$ninint,bP,z,pap,papi,nI,lP);
  names(bigparl) = c("I","ntranst","ninit","ntransnt","ninint","bP","z","pap","papi","nI","lP");
  
  return(bigparl);
}

#
#update p_s using the rejection sampling
updatep = function(p,pap,pub,delta){  
    for (s in 1:3) {
      if (s==1) {
        p[s] = rcpprejbeta(0,pub - delta,pap[s,1],pap[s,2],1);
      } else if (s==2) {
        p[s] = rcpprejbeta(0,pub - delta,pap[s,1],pap[s,2],1);      
      } else {
        p[s] = rcpprejbeta(pub + delta,1,pap[s,1],pap[s,2],3);
      }
    }
  return (p);
}


#update pi_s using the rejection sampling
updatepi = function(pi,papi){
  for (s in 1:3) {
    if (s==1) {
      pi[s] = rbeta(1,papi[s,1],papi[s,2]); 
    }
    else if (s==2) {
      pi[s] = rbeta(1,papi[s,1],papi[s,2]); 
    }
    else if (s==3) {
      pi[s] = 0;
    }
  }
  return (pi);
}



#draw missing data Z|pi,p,I,X,M
#z=1 if zero state; 0 otherwise
genz = function(datalen,pi,p,I,X,M) {
  odd = pi/(1-pi)
  pz = odd[I] / (odd[I] + (1-p[I])^X)
  pz[is.na(pz) | M > 0] = 0;
  z = as.logical(rbinom(datalen,1,pz))
  return(z)
}


#sample markov kernel. each row ~ dirichlet
#len = number of mh samples
#transition probs are bounded for numerically stability.
mhT = function(pat1,pat2,pat3,pas) {
  T = constrkernel(pat1,pat2,pat3);
  T$phit = rdirichlet(pas$t);
  #T$phit = c(T$phit[-3],0);
  T$phint = c(rdirichlet(pas$nt),0);
  return(T)
}

#construct a markov kernel.
#Markov transition kernel
#T = [ t_11 t_12 0   ]
#    [ t_21 t_22 t_23]
#    [ 0      1  0   ]
constrkernel = function(at1,at2,at3) {
  t1 = c(rdirichlet(at1),0)
  t2t = rdirichlet(at2$t)
  t2nt = c(rdirichlet(at2$nt),0)
  t3t = c(0,rdirichlet(at3))
  t3nt = c(0,1,0)
  mkernel = list();
  mkernel$t = t(matrix(c(t1,t2t,t3t),3,3))
  mkernel$nt = t(matrix(c(t1,t2nt,t3nt),3,3))
  if (mkernel$t[2,3] == 0){
    warning("zero prob on T[2,3]", .call=FALSE)
  }
  return(mkernel)
}

# sample from Dirichlet distributions
rdirichlet = function(alpha) {
  dim = length(alpha)
  result = numeric(dim)
  for(i in 1:dim){
    result[i] = rgamma(1,alpha[i],1)
  }
  result = result / sum(result)
  return(result)
}

# combine parallelized outcomes
combparl = function(bigparl,nsv,c) {
  I = c();
  lI = list();
  nI = rep(as.integer(0),3);
  bP = c();
  z = c();
  ninit = rep(as.integer(0),3);
  ntranst = matrix(as.integer(0),3,3);
  ninint = rep(as.integer(0),3);
  ntransnt = matrix(as.integer(0),3,3);
  pap = matrix(0,3,2);
  papi = matrix(0,3,2);
  mnI = matrix(0,3,nsv);
  
  for (sv in 1:nsv) {
    I = c(I,bigparl[[sv]]$I);
    lI[[sv]] = bigparl[[sv]]$I;
    nI = nI + bigparl[[sv]]$nI;
    mnI[,sv] = bigparl[[sv]]$nI;
    bP = cbind(bP,bigparl[[sv]]$bP);
    ninit = ninit + bigparl[[sv]]$ninit;
    ntranst = ntranst + bigparl[[sv]]$ntranst;
    ninint = ninint + bigparl[[sv]]$ninint;
    ntransnt = ntransnt + bigparl[[sv]]$ntransnt;
    z = c(z,bigparl[[sv]]$z);
    pap = pap + bigparl[[sv]]$pap;
    papi = papi + bigparl[[sv]]$papi;
  }
  nini = list(t = ninit, nt = ninint);
  ntrans = list(t = ntranst, nt = ntransnt);
  combparl = list(I,bP,nini,ntrans,z,pap,papi,nI,mnI,lI);
  names(combparl) = c("I","bP","nini","ntrans","z","pap","papi","nI","mnI","lI");
  return(combparl)
}

# discard locations with read counts <= c. 
# Then, discard regions of length < ml
filtout = function(bases,c,ml) {
  bases = bases[bases$tag > c,]
  reg.len = aggregate(bases$tag, by=list(region = bases$region_id), length)
  bases = bases[bases$region_id %in% reg.len$region[reg.len$x >= ml],]
  return (bases);
}

# parameter transformation
fparam = function(kab) {
  fkab = kab;
  fkab[,2] = log(kab[,2]) - log(kab[,3]);
  fkab[,3] = - log(kab[,2] + kab[,3]);
  return(fkab);
}

# parameter back-transformation
bparam = function(fkab) {
  kab = fkab;
  mu = exp(fkab[,2])/(1+exp(fkab[,2]));
  theta = exp(fkab[,3]);
  kab[,1] = 1
  kab[,2] = mu/theta;
  kab[,3] = (1-mu)/theta;
  return(kab);
}

########################################################################
#update kab - 2 dim random walk proposal: sequential, tabulate
#reparametrization
########################################################################
tabupdatekab = function(kab,akab,X,maxx,c,I,csig){
  acc = matrix(rep(0,9),3,3);
  logrd = numeric(3);
  mbnb = numeric(3);
  dummy = 0:maxx;  
  seq = list(2,c(2,3));
  fkab = fparam(kab);
  tabx = foreach(s = 1:3) %dopar% table(c(X[I==s],dummy));
  tabx[[1]] = as.integer(tabx[[1]] - 1);
  tabx[[2]] = as.integer(tabx[[2]] + tabx[[3]] - 2);   
  
  for (i in 1:2) {
    logrd[i] = ctablogbnb(tabx[[i]],kab[i,],c,(i-1)) +
      sum(dnorm(fkab[i,seq[[i]]], akab[1], akab[2], log = TRUE));
    mbnb[i] = cmombnb(kab[i,],c,(i-1));
  }
  
  mbnb[3] = mbnb[2];
  logrd[3] = logrd[2]; 
  
  ltemp = fkab;
  
  for (i in 1:2) {
    tmbnb = mbnb;
    ok = 0;
    ltemp[i,2:3] = csig[[i]]%*%rnorm(2,0,1) + fkab[i,2:3];
    ltemp[1,3] = -10;
    temp = bparam(ltemp);
    tmbnb[i] = cmombnb(temp[i,],c,(i-1));
    if (tmbnb[1] <= tmbnb[2]) {
      ok = 1;
    }
    
    # the MH sampler.
    # random walk proposal is used.
    # reject a proposal sample unless samples obey the constraints
    if (ok == 1){
      logrn = ctablogbnb(tabx[[i]],temp[i,],c,(i-1)) +
        sum(dnorm(ltemp[i,seq[[i]]], akab[1], akab[2], log = TRUE));
      logr = logrn - logrd[i];      
      if (log(runif(1)) < logr) {
        kab = temp;
        acc[i,2:3] = 1;
        mbnb[i] = tmbnb[i];
        logrd[i] = logrn;
      }
    }
  }
  
  kab[3,] = kab[2,];
  mbnb[3] = mbnb[2];
  
  lkab = list(kab=kab,acc=acc,logrd = logrd,mom = mbnb);
  return(lkab);
}

# compute FDRs
fdr = function(mc,cut) {
  rule = mc$IP[3,]>=cut;
  prob = mc$IP[3,][rule];
  return(sum(1-prob) / sum(rule));
}

ranking = function(datachr,mc,lb,c,ml) {
  datachr = filtout(datachr,mc$c,1);
  ranked = numeric(0);
  prei = 1.001;
  for (i in seq(1,lb,-0.001)) {
    tap = datachr[mc$IP[3,] >= i & mc$IP[3,] < prei,];
    PI3 = mc$IP[3,mc$IP[3,] >= i & mc$IP[3,] < prei];
    tap = cbind(tap,PI3);
    ranked = rbind(ranked,tap);
    prei = i;
  }
  return(ranked);
}