\name{bases}
\alias{bases}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
An example PAR-CLIP data set
}
\description{
This is a short example of PAR-CLIP dataset. Aligned read seuqneces are converted to read and mutation counts in each genomic location. Only T to C substitutions are kept, and non-clustered reads are discarded.
}
\usage{
data(bases)
}
\format{
  \describe{
\item{tag}{
\code{integer} Read counts
}
\item{mutant}{ 
\code{integer} Mutation counts (T to C substitutions)
}
\item{region_id}{ 
\code{string} ID that is assigned to a CLIP cluster
}
\item{chr}{ 
\code{string} Chromosome
}
\item{strand}{ 
\code{string} Strand information
}
\item{nt}{
\code{string} Nucleotide sequence
}
\item{pos}{
\code{integer} Genomic location
}
}
}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
%\value{
%\item{sumc}{Description of 'comp1'}
%\item{IP}{Description of 'comp2'}
%
%}
%\references{
%% ~put references to the literature/web site here ~
%}
%\author{
%%  ~~who you are~~
%}
%\note{
%%  ~~further notes~~
%}
%% ~Make other sections like Warning with \section{Warning }{....} ~
%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
require(rcpphmmparclip)
require(ggplot2)
data(bases)
attach(bases)
rid = 85974;
ridx = (region_id == rid);
rlen = sum(ridx);

x = rep(as.factor(pos[ridx]),2);
y = c(tag[ridx] - mutant[ridx],mutant[ridx]);
factor = as.factor(c(rep("read",rlen),rep("mutation",rlen)))
qplot(x,geom="bar", weight=y, fill = factor, xlab='Genomic Location',
      title='Graphical representation of a CLIP cluster')
}
