\name{fbgibbs}
\alias{fbgibbs}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
The forward-backward Gibbs sampler
}
\description{
This function estimates posterior probabilities of binding sites, posterior means of parameters. The function also provides the posterior predictive checking. 
}
\usage{
fbgibbs(data, c = 3, p = c(0.04, 0.02, 0.3), pi = c(0.5, 0.5, 0),
                   fkab = t(matrix(c(1,-1,0,
                                     1,1,0.05,
                                     1,1,0.05),3,3)),
                   K_T = matrix(c(0.98, 0.02, 0.00,
                                  0.05, 0.92, 0.03,
                                  0.00, 0.99, 0.01),3,3),
                   K_N2 = c(0.05, 0.95, 0.00),
                   phi_T = c(0.90, 0.1, 0.00),
                   epsil = 0.195, delta = 0.005, tot = 10000, burnp = 0.5, 
                   nsv = 1, doppc = FALSE, doprintout = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
PAR-CLIP data to be analysed. See ...
}
\item{c}{
  The truncation value for read counts.
}
  \item{p,pi}{
Initial values of mutation probabilities \eqn{p_s} and zero-inflated probabilities \eqn{\pi_s}.
}
  \item{fkab}{
Initial values of parameters in the beta geometric distribution.
}
  \item{K_T}{
Initial values of transition matirx \eqn{K_T} on T-sites.
}
  \item{K_N}{
Initial values of the 2nd row of the transition matrix \eqn{K_N} on non T-sites.
}
  \item{phi_T}{
Initial values of the initial distribution on T-sites of hidden Markov chains.  
}
  \item{epsil}{
  The upper bound \eqn{\epsilon} of mutation probabilities on non-binding sites.
}
  \item{delta}{
  The lower bound \eqn{\epsilon + \delta} of mutation probabilities on binding sites.
}
  \item{tot}{
  The maximum number of MCMC iterations.
}
  \item{burnp}{
  The proportion of MCMC chains to be burnt out.
}
  \item{nsv}{
  The number of cores to be used for parallel computing.
}
  \item{doppc}{
  If \code{TRUE}, the posterior predictive checking is carried out. However, this option will slow down the FB Gibbs sampler.
}
  \item{doprintout}{
  If \code{TRUE}, summeries for each MCMC chains will be provided.
}
}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\value{
\item{IP}{[,3] Posterior probability of the binding site}
\item{ppc}{The p-value for the posterior predtive checking}
\item{sumc}{posterior means of parameters}
\item{sumc$bg}{posterior means of parameters in the BG. [,2]: \eqn{\mu_s} and [,3]: \eqn{\eta_s}}
}
\seealso{
\code{\link{bases}}
}
\examples{
require(rcpphmmparclip)
require(doMC)
require(parallel)

tcore = detectCores()
cl <- makeCluster( tcore )
registerDoMC()

data(bases)

mc = fbgibbs(bases,tot=100,nsv=tcore);

# print sites with the posterior probability >= postcut.
postcut = 0.8;
ranking(bases,mc,postcut);
# estimate FDR on these sites.
fdr(mc,postcut);

stopCluster(cl)
rm(cl)
}

