\name{rcpphmmparclip-package}
\alias{rcpphmmparclip-package}
\docType{package}
\title{Rcpp functions for analysing PAR-CLIP using the HMM}
\description{
This package provides essential functions for the forward-backward Gibbs sampler to snalyse PAR-CLIP data using the HMM. 
}
\details{
To install this package, windows users may require to install Rtools (http://cran.r-project.org/bin/windows/Rtools/), which will help to compile the Rcpp functions in your machine. It is recommended to install both R and Rtools in directories whose names have no space. More details about how to build the package is provided in Rcpp-FAQ (http://dirk.eddelbuettel.com/code/rcpp/Rcpp-FAQ.pdf).

To install the package,

\code{install.packages('rcpphmmparclip_0.1.0.tar.gz',type='source')}
}
\author{Jonghyun Yun <jonghyun yun@utsouthwestern.edu>
}
\references{
Yun, J., Wang, T. and Xiao, G. (2013). Bayesian HMMs to Identify RNA-Protein Interaction
Sites in PAR-CLIP. Biometrics (under revision).
}
\seealso{
\code{\link{bases}}, \code{\link{fbgibbs}}
}
\examples{
require(rcpphmmparclip)
require(doMC)
require(parallel)

tcore = detectCores()
cl <- makeCluster( tcore )
registerDoMC()

data(bases)

mc = fbgibbs(bases,tot=100,nsv=tcore);

# print sites with the posterior probability >= postcut.
postcut = 0.8;
ranking(bases,mc,postcut);
# estimate FDR on these sites.
fdr(mc,postcut);

stopCluster(cl)
rm(cl)
}
