#include "cbackS.h"

// [[Rcpp::export]]

List cbackS(IntegerVector poslen, int datalen, int reglen, IntegerVector csum,
        const LogicalVector tn, const NumericMatrix lP) {
    const double eps = std::numeric_limits<double>::denorm_min();
    double ninf = log(0.0);

    IntegerVector I(datalen);
    IntegerMatrix transt(3, 3);
    IntegerVector init(3);
    IntegerMatrix transnt(3, 3);
    IntegerVector inint(3);
    double unif = 0;
    double sunif = 0;
    double cump = 0;
    int getpos = 0;
    int tripos = 0;
    int s = 0;
    int r = 0;
    int hit = 0;
    double lpvec[3];
    double* pvec = new double[3];

    RNGScope scope;

    for (int j = 0; j < reglen; j++) {
        for (int i = (poslen[j] - 1); i >= 0; i--) {
            getpos = i + csum[j];
            tripos = 3 * getpos;
            unif = ::Rf_runif(0.0, 1.0);
            if (i == (poslen[j] - 1)) {
                cump = 0;
                r = 0;
                hit = 0;
                while (hit == 0) {
                    cump += exp(lP(3, r + tripos));
                    if (unif <= cump) {
                        I[getpos] = (r + 1);
                        hit = 1;
                    }
                    r += 1;
                }
            } else {
                s = (I[getpos + 1] - 1);
                if (s == 0) {
                    for (int k = 0; k < 2; k++) {
                        lpvec[k] = lP(k, s + tripos + 3);
                    }
                    pvec = fcump(lpvec, 2, eps, ninf);
                    sunif = unif * pvec[1];
                    if (sunif <= pvec[0]) {
                        r = 0;
                    } else r = 1;
                } else if (s == 1) {
                    for (int k = 0; k < 3; k++) {
                        lpvec[k] = lP(k, s + tripos + 3);
                    }
                    pvec = fcump(lpvec, 3, eps, ninf);
                    r = 0;
                    hit = 0;
                    if (tn[getpos]) {
                        sunif = unif * pvec[2];
                    } else {
                        sunif = unif * pvec[1];
                    }
                    while (hit == 0) {
                        if (sunif <= pvec[r]) {
                            hit = 1;
                        } else {
                            r += 1;
                        }
                    }
                } else if (s == 2) {
                    if (tn[getpos]) {
                        for (int k = 0; k < 3; k++) {
                            lpvec[k] = lP(k, s + tripos + 3);
                        }
                        pvec = fcump(lpvec, 3, eps, ninf);
                        r = 1;
                        hit = 0;
                        sunif = unif * (pvec[2] - pvec[0]);
                        while (hit == 0) {
                            if (sunif <= (pvec[r] - pvec[0])) {
                                hit = 1;
                            } else {
                                r += 1;
                            }
                        }
                    } else {
                        r = 1;
                    }
                }
                I[getpos] = (r + 1);
                if (tn[getpos]) {
                    transt(r, s) += 1;
                } else {
                    transnt(r, s) += 1;
                }
            }
            if (i < 1) {
                if (tn[getpos]) {
                    init[r] += 1;
                } else {
                    inint[r] += 1;
                    if (r == 2) {
                    }
                }
            }
        }
    }

    List out = List::create(Rcpp::Named("I") = I,
            Rcpp::Named("ntranst") = transt,
            Rcpp::Named("ninit") = init,
            Rcpp::Named("ntransnt") = transnt,
            Rcpp::Named("ninint") = inint);
    return out;
}
