#include <limits>
#include <math.h>
#include <Rcpp.h>
using namespace Rcpp; // inline does that for us already

double* fcump(double lpvec[], unsigned int len, double eps, double ninf) {
    double *pvec = new double [3];
    for (unsigned int s = 0; s < len; s++) {
        pvec[s] = exp(lpvec[s]);
        if (s > 0) {
            pvec[s] += pvec[s - 1];
        }
    }
    if (pvec[(len - 1)] <= eps) {
        double mean = 0;
        int nni = 0;
        for (unsigned int k = 0; k < 2; k++) {
            if (lpvec[k] > ninf) {
                mean += lpvec[k];
                nni += 1;
            }
        }
        mean /= nni;
        for (unsigned int q = 0; q < len; q++) {
            pvec[q] = exp(lpvec[q] - mean);
            if (q > 0) {
                pvec[q] += pvec[q - 1];
            }
        }
    }
    if (pvec[(len - 1)] < eps) {
        for (unsigned int s = 0; s < 3; s++) {
            pvec[s] = (s + 1) / len;
        }
    }
    if (len < 3) {
        pvec[2] = 0;
    }
    return pvec;
    delete pvec;
}
