#include <Rcpp.h>
using namespace Rcpp;

// [[Rcpp:export]]

List cgenrep(LogicalVector tn, int tlen, int c, NumericMatrix kab, NumericVector p, NumericVector pi, IntegerVector I) {

    NumericVector X(tlen);
    NumericVector M(tlen);
    int s;
    const int d = c + 1;

    for (int k = 0; k < tlen; k++) {
        s = I[k] - 1;
        if (s == 0) {
            X[k] = d + Rf_rnbinom(kab(s, 0), kab(s, 1) / (kab(s, 1) + kab(s, 2)));
        } else {
            X[k] = d + Rf_rnbinom(kab(s, 0), Rf_rbeta(kab(s, 1), kab(s, 2)));
        }
        if ((Rf_runif(0.0, 1.0) > pi[s]) && tn[k]) {
            M[k] = Rf_rbinom(X[k], p[s]);
        } else {
            M[k] = 0;
        }
    }

    List out = List::create(Named("M") = M,
            Named("X") = X);

    return out;
}
