#include "hmmlike.h"

// [[Rcpp::export]]

double cloglike(const IntegerVector X, const IntegerVector M, const LogicalVector tn, const NumericMatrix kab,
        const NumericVector p, const NumericVector pi, const int c, const IntegerVector I, const int datalen) {
    double like = 0;
    double pbnbr[3];
    double lomp[3];
    int s;
    const int d = c + 1;

    for (int r = 0; r < 3; r++) {
        lomp[r] = log(1 - pi[r]);
        pbnbr[r] = lnormcbnb(kab(r, 0), kab(r, 1), kab(r, 2), r);
    }

    for (int getpos = 0; getpos < datalen; getpos++) {
        s = I[getpos] - 1;
        if (!tn[getpos]) {
            like += lbnbr(X[getpos], d, kab(s, 0), kab(s, 1), kab(s, 2), s) - pbnbr[s];
        } else {
            like += fzib(X[getpos], M[getpos], p[s], pi[s], lomp[s]) +
                    lbnbr(X[getpos], d, kab(s, 0), kab(s, 1), kab(s, 2), s) - pbnbr[s];
        }
    }
    return like;
}
