#include "hmmlike.h"

// [[Rcpp:export]]

double cmombnb(const NumericVector kab, const int c, const int s) {
    const int d = c + 1;
    const double pbnbr = lnormcbnb(kab[0], kab[1], kab[2], s);
    double mean = 0;

    if (kab[1] > 1) {
        mean = kab[0] * kab[2] / (kab[1] - 1) + c;
    } else {
        for (int x = d; x <= 500; x++) {
            //printf("mean= %f /n", mean);
            mean += x * exp(lbnbr(x, d, kab[0], kab[1], kab[2], s) - pbnbr);
        }
    }

    return mean;
}
