#include "hmmlike.h"

// [[Rcpp::export]]

double ctablogbnb(const IntegerVector tabx, const NumericVector kab,
        const int c, const int s) {
    const int d = c + 1;
    const double pbnbr = lnormcbnb(kab[0], kab[1], kab[2], s);
    double like = 0;
    int tabsize = tabx.size();

    for (int k = 0; k < tabsize; k++) {
        if (tabx[k] > 0) {
            like += (lbnbr(k, d, kab[0], kab[1], kab[2], s) - pbnbr) * tabx[k];
        }
    }
    return like;
}
