#include <math.h>  
#include <limits>
#include <Rcpp.h>

using namespace Rcpp;

inline double lbnbr(int X, int d, double k, double a, double b, int s) {
    double like = 0;
    if (s == 0) {
        like = Rf_dnbinom(X - d, k, a / (a + b), 1);
    } else {
        like = Rf_lgammafn(X - d + k) - Rf_lgammafn(X - d + 1)
                + Rf_lbeta(a + k, b + X - d);
    }
    return (like);
}

inline double sfbnbr(int ub, int d, double k, double a, double b, int s) {
    double lp = 0;
    double p;
    if (s == 0) {
        lp = Rf_pnbinom((ub - 1), k, a / (a + b), 1, 0);
    } else {
        for (int x = d; x < ub; x++) {
            lp += exp(lbnbr(x, d, k, a, b, s) - (Rf_lgammafn(k) + Rf_lbeta(a, b)));
        }
    }
    p = 1 - lp;
    if (p <= 0) {
        p = 0;
    }
    return (p);
}

inline double lnormcbnb(double k, double a, double b, int s) {
    double c = 0;
    if (s == 0) {
        c = 0;
    } else {
        c = Rf_lgammafn(k) + Rf_lbeta(a, b);
    }
    return (c);
}

inline double fzib(double X, double M, double p, double pi, double lomp) {
    double like = 0;
    if (M > 0) {
        like = lomp + Rf_dbinom(M, X, p, 1);
    } else {
        like = log(pi + (1 - pi) * pow(1 - p, X));
    }
    return (like);
}
