#include <Rcpp.h>
using namespace Rcpp; // inline does that for us already

// [[Rcpp::export]]

double rcpprejbeta(double lb, double ub, const double a, const double b, const int s) {
    double limpmr = 0;
    int acc = 0;
    double ldbeta;
    double temp = 0;
    double lunif;
    double mp;
    double acctemp = 0;

    if (s < 2) {
        limpmr = log(ub) - Rf_pbeta(ub, a, b, 1, 1);
        lb = 0;
    } else if (s < 3) {
        const double eps = std::numeric_limits<double>::denorm_min();
        mp = (Rf_pbeta(ub, a, b, 1, 0) - Rf_pbeta(lb, a, b, 1, 0));
        if ((mp < eps) && (Rf_pbeta(lb, a, b, 1, 0) < eps)) {
            limpmr = log(ub - lb) - Rf_pbeta(ub, a, b, 1, 1);
        } else if (mp < eps) {
            double mlog = 0;
            mlog += Rf_pbeta(ub, a, b, 1, 1);
            mlog += Rf_pbeta(lb, a, b, 1, 1);
            mlog /= mlog / 2;
            limpmr = log(ub - lb) - log(exp(Rf_pbeta(ub, a, b, 1, 1) - mlog)
                    - exp(Rf_pbeta(lb, a, b, 1, 1) - mlog));
            /*       limpmr = 1000000000000;
            if (Rf_pbeta(ub, a, b, 0, 1) > Rf_pbeta(lb, a, b, 1, 1)){
                    temp = ub;
                    acc = 1;
                    }
            else if (Rf_pbeta(ub, a, b, 0, 1) <= Rf_pbeta(lb, a, b, 1, 1)) {
                temp = lb;
                acc = 1;
            }       
             */
        } else {
            limpmr = log(ub - lb) - log(mp);
        }
    } else if (s < 4) {
        limpmr = log(1.0 - lb) - Rf_pbeta(lb, a, b, 0, 1);
        ub = 1;
    }

    RNGScope scope; // Initialize Random number generator

    while (acc == 0) {
        temp = Rf_runif(lb, ub);
        lunif = log(Rf_runif(0.0, 1.0));
        ldbeta = Rf_dbeta(temp, a, b, 1);
        //printf("ldbeta + limpmr = %f + %f = %f",ldbeta,limpmr,ldbeta + limpmr);
        if (lunif < (ldbeta + limpmr)) {
            acc = 1;
        }
    }
    acctemp = temp;
    return acctemp; // Return to R
}
