// this function initializes the Cluster struct
struct Cluster *ini_Cluster()
{
  struct Cluster *cluster_p=(struct Cluster*)malloc(sizeof(struct Cluster));
  if (cluster_p==NULL) {return NULL;}

  cluster_p->chr=NULL;
  cluster_p->strand='n';
  cluster_p->id=0;
  cluster_p->start=0;
  cluster_p->end=0;
  cluster_p->raw=NULL;
  cluster_p->binned=NULL;
  cluster_p->next=NULL;

  return cluster_p;
}

// this function frees the list comprised of Cluster structs
void free_Cluster(struct Cluster *x)
{
  if (x->next!=NULL) {free_Cluster(x->next);}
  free(x->chr);
  free_matrix(x->raw);
  free_matrix(x->binned);
  free(x);
}

// this function reads the header line and the count matrix of one cluster
// this functino also chains the Cluster structs automatically by dynamic programming
struct Cluster *get_Cluster(unsigned long id,int GROUP,FILE *file,int step)
{
  char *tmp,line[MAX_LINE];
  unsigned long i,j;
  struct Cluster *cluster_p;

  if (fgets(line,sizeof line,file)==NULL) {return NULL;} // reached end of file
  cluster_p=ini_Cluster(); // initialize Cluster struct
  if (cluster_p==NULL) {return NULL;}
 
  // read header line
  cluster_p->id=id;
  strtok(line,"\t");
  hard_copy(&cluster_p->chr,strtok(NULL,"\t"));
  if ((tmp=strtok(NULL,"\t"))==NULL) {return NULL;}
  cluster_p->strand=tmp[0];
  sscanf(strtok(NULL,"\t"),"%lu",&(cluster_p->start));
  sscanf(strtok(NULL,"\t"),"%lu",&(cluster_p->end));
  if (cluster_p->chr==NULL || cluster_p->strand=='n' || cluster_p->start==0 || cluster_p->end==0) 
  {
    free_Cluster(cluster_p);
    return NULL;
  }

  // read the raw matrix and fill binned matrix
  cluster_p->raw=create_matrix(cluster_p->end-cluster_p->start+1,2*GROUP);
  cluster_p->binned=create_matrix((cluster_p->end-cluster_p->start+1)/step,2*GROUP);
  if (cluster_p->raw==NULL || cluster_p->binned==NULL) 
  {
	free_Cluster(cluster_p);
    return NULL;
  }

  // process each tag that forms the cluster
  for (i=0;i<=cluster_p->end-cluster_p->start;i++)
  {
	if (fgets(line,sizeof line,file)==NULL) // get each line
	{
	  free_Cluster(cluster_p);
	  return NULL;
	}
	
	if ((tmp=strtok(line,"\t"))==NULL) {return NULL;} // read the first element of each line
	sscanf(tmp,"%lf",&(cluster_p->raw->values[i][0]));

	for (j=1;j<2*GROUP;j++) // read the rest of the line
	{
	  if ((tmp=strtok(NULL,"\t"))==NULL) {return NULL;}
	  sscanf(tmp,"%lf",&(cluster_p->raw->values[i][j]));
	} 

	if ((i+1)%step==0) // fill binned matrix
	{
	  for (j=0;j<2*GROUP;j++) {cluster_p->binned->values[i/step][j]=sum_subset(cluster_p->raw,i+1-step,i,j,j);}
	}
  }

  cluster_p->next=get_Cluster(++id,GROUP,file,step); // read the next Cluster
  return cluster_p;
}
