// this function is used to create a x by y matrix
struct Matrix *create_matrix(unsigned long x,unsigned long y)
{
  struct Matrix *matrix;
  unsigned long i,j;

  // create Matrix struct
  matrix=(struct Matrix *)malloc(sizeof(struct Matrix));
  if (matrix==NULL) {return NULL;}

  // row and col
  matrix->row=x;
  matrix->col=y;

  matrix->values=(double **)malloc(x*sizeof(double*));  // create column
  if(matrix->values==NULL) {return NULL;}

  for(i=0;i<x;i++) // create row
  {
    matrix->values[i]=(double *)malloc(y*sizeof(double));
    if(matrix->values[i]==NULL) {return NULL;}
	for (j=0;j<y;j++) {matrix->values[i][j]=0;} // initialize each point
  }

  return matrix;
}

// this function is for freeing matrix
void free_matrix(struct Matrix *matrix)
{
  unsigned long i;

  if (matrix==NULL) {return;}
  for (i=0;i<matrix->row;i++) {free(matrix->values[i]);}
  free(matrix->values);
  free(matrix);
}

// this function is for matrix multiplication
struct Matrix *multi(struct Matrix *m1,struct Matrix *m2)
{
  struct Matrix *m3;
  unsigned long new_r,new_c,i;

  if (m1->col!=m2->row) {return NULL;}
  m3=create_matrix(m1->row,m2->col);
  if (m3==NULL) {return NULL;}

  for (new_r=0;new_r<m3->row;new_r++)
  {
    for (new_c=0;new_c<m3->col;new_c++)
	{
	  for (i=0;i<m1->col;i++) {m3->values[new_r][new_c]+=(m1->values[new_r][i]*m2->values[i][new_c]);}
	}
  }

  return m3;
}

// this function is for point-by-point multiplication for two matrices
struct Matrix *pbp_multi(struct Matrix *m1,struct Matrix *m2)
{
  unsigned long i,j;
  struct Matrix *m3;

  if (m1->row!=m2->row || m1->col!=m2->col) {return NULL;}
  m3=create_matrix(m1->row,m1->col);
  if (m3==NULL) {return NULL;}

  for (i=0;i<m3->row;i++)
  {
    for (j=0;j<m3->col;j++) {m3->values[i][j]=m1->values[i][j]*m2->values[i][j];}
  }

  return m3;
}

// this function is for summation of the values within one subset block of a matrix
// if indices are out of bounds, an error will be issued
// r1, r2, c1, c2 are the coordinates of the subset block
double sum_subset(struct Matrix *m,unsigned long r1,unsigned long r2,unsigned long c1,unsigned long c2)
{
  unsigned long i,j;
  double sum=0;

  if (r1<0 || c1<0 || r2>=m->row || c2>=m->col) 
  {
	printf("Index out of range!\n");
	exit(3);
  }

  for (i=r1;i<=r2;i++) 
  {
    for (j=c1;j<=c2;j++) {sum+=m->values[i][j];}
  }

  return sum;
}

// this function print matrix to stdout for viewing
void print_matrix(struct Matrix *m)
{
  unsigned long i,j;

  for (i=0;i<m->row;i++)
  {
	for (j=0;j<m->col;j++) {printf("%lf\t",m->values[i][j]);}
	printf("\n");
  }

  printf("\n");
}
