//////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////  define drop and free function  /////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////

// this funciton frees all the Read structs
// if file is NULL, then don't print
void free_leaf(struct Read *read_p,FILE *file)
{
  if (read_p==NULL) {return;}

  // free branches
  free_leaf(read_p->smaller,file);
  if (file!=NULL) {fprintf(file,"%s\t%d\t%s\t%c\t%s\t%s\t%s\t%lu\t%d\n", \
  read_p->name,read_p->group,read_p->chr,read_p->strand,read_p->seq,read_p->CIGAR,read_p->MD,read_p->pos,read_p->len);}
  free_leaf(read_p->bigger,file);
  
  // free the leaf itself
  free(read_p->chr);
  free(read_p->CIGAR);
  free(read_p->MD);
  free(read_p->name);
  free(read_p->seq);
  free(read_p);
}

// this function is for deciding the order of any two Read structs
// 2: a is before b, 
// 1: a and b occupy the same position but retain a
// -1: a and b occupy the same position but retain b
// -2: a is after b
int compare(struct Read *a,struct Read *b,char duplicate)
{
  int cmp_seq;

  if (a->pos<b->pos) {return 2;}
  else if (a->pos>b->pos) {return -2;}

  if (a->len<b->len) {return 2;}
  else if (a->len>b->len) {return -2;}

  if (a->group<b->group) {return 2;}
  else if (a->group>b->group) {return -2;}

  if (duplicate=='a') {if (a->qual>b->qual) {return 2;} else {return -2;}} // all reads are kept, comparison halts here

  if (duplicate=='s') // all reads that have the same sequence are collapsed
  {
    cmp_seq=strcmp(a->seq,b->seq);
    if (cmp_seq>0) {return 2;} else if (cmp_seq<0) {return -2;} // if sequences differ, an order is given and comparison halts
  } 

  // if the sequences are the same (s) or all reads that have the same mapping coordinates should be collapsed (c)
  if (a->qual>b->qual) {return 1;} else {return -1;} 
}

// this function drop the Read struct down the Read list (leaves)
void drop_leaf(struct Read **leaf_p,struct Read *new_leaf,char duplicate)
{
  if (*leaf_p==NULL) // the new_leaf has reached the tip of the branch
  {
    *leaf_p=new_leaf;
  }else 
  {
    switch (compare(*leaf_p,new_leaf,duplicate))
	{
	  case -2: // the new leaf goes to the smaller branch
		drop_leaf(&((*leaf_p)->smaller),new_leaf,duplicate);
	    break;
	  case -1: // copy the new leaf
		// free the content of the old leaf
        free((*leaf_p)->CIGAR);
        free((*leaf_p)->MD);
        free((*leaf_p)->name);
        free((*leaf_p)->seq);
		// copy the content of new leaf to the old leaf
		(*leaf_p)->CIGAR=new_leaf->CIGAR;
		(*leaf_p)->MD=new_leaf->MD;
		(*leaf_p)->name=new_leaf->name;
		(*leaf_p)->seq=new_leaf->seq;
		(*leaf_p)->qual=new_leaf->qual;
		// free the new leaf struct
		free(new_leaf->chr);
		free(new_leaf);
	    break;
	  case 1: // retain the old leaf
		free_leaf(new_leaf,NULL); // don't print
	    break;
	  case 2: // the new leaf goes to the bigger branch
		drop_leaf(&((*leaf_p)->bigger),new_leaf,duplicate);
	    break;
	}
  }
}

// this function will drop the Read struct down the Chrstrand list (find correct tree for each leaf)
int drop_tree(struct Chrstrand **head_p_p,struct Read *read_p,char duplicate)
{
  char strand=read_p->strand;

  // create the head of the Chrstrand list
  if ((*head_p_p)==NULL) 
  {
    *head_p_p=(struct Chrstrand*)malloc(sizeof(struct Chrstrand));
	if ((*head_p_p)==NULL) {return 0;}
	(*head_p_p)->len=0;
  }

  // if the Chrstrand struct is not built yet
  if ((*head_p_p)->len==0)
  {
    hard_copy(&((*head_p_p)->chr),read_p->chr);
    (*head_p_p)->strand=strand;
    (*head_p_p)->len=1;
    (*head_p_p)->next=(struct Chrstrand*)malloc(sizeof(struct Chrstrand));
    if ((*head_p_p)->next==NULL) {return 0;}
    (*head_p_p)->next->len=0;
    (*head_p_p)->read_p=read_p;
    return 1;
  // if the Chrstrand struct does not match the chr and strand of Read struct
  } else if (strcmp((*head_p_p)->chr,read_p->chr)!=0 || (*head_p_p)->strand!=strand)
  {
    return drop_tree(&((*head_p_p)->next),read_p,duplicate);
  }else
  // drop the Read struct down the Read list (leaves)
  {
    drop_leaf(&((*head_p_p)->read_p),read_p,duplicate);
    ((*head_p_p)->len)++;
    return 1;
  }
}

// this funciton frees all the Chrstrand structs
void free_tree(struct Chrstrand *head_p,FILE *file)
{
  struct Read *read_p;
  // go to each Chrstrand struct
  if (head_p->next->len!=0) {free_tree(head_p->next,file);}
  else {free(head_p->next);}
  //free each Chrstrand struct
  read_p=head_p->read_p;
  free(head_p->chr);
  free(head_p);
  //free each Read struct
  free_leaf(read_p,file);
}

