#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include"sam.h"
// exit 0: success
// exit 1: file handle creation problem
// exit 2: memory allocation problem
// exit 3: computation error (divided by 0, subscripts out of bounds...)
// the first parameter is the temporary file to store clusters
// the second parameter is the temporary file to store raw total/mutant count
// the third parameter is the mutation type string
// the fourth and following parameters are the alignment replicates
int main(int argc,char *argv[])
{
  // define variables
  char *intermediate_file1,*intermediate_file2,*muts;
  char line[MAX_LINE],duplicate;
  struct Chrstrand *head_p=NULL;
  struct Read *read_p;
  unsigned int parsed_muts;
  char *raw_files[MAX_FILE],*replicate;
  int GROUP,group;
  FILE *file,*file1,*file2;

  // accept input variables
  GROUP=argc-5;
  if (GROUP>MAX_FILE) 
  {
    printf("Too many alignment files!\n");
    exit(3);
  }

  for (group=0;group<GROUP;group++) {raw_files[group]=argv[group+5];}
  intermediate_file1=argv[1];
  intermediate_file2=argv[2];
  muts=argv[3];
  duplicate=argv[4][0]; // whether to keep duplicate, 'c', 's' or 'a'

  // read, unique, order and write sequencing reads
  // reads from each file will be assigned a "group" id
  for (group=1;group<=GROUP;group++)
  {
    file=fopen(raw_files[group-1],"r");
    if (file==NULL) {exit(1);}
  
    while (fgets(line,sizeof line,file)!=NULL)
    {
      read_p=get_Read(line,group);
      if (read_p==NULL) {continue;}
      if (drop_tree(&head_p,read_p,duplicate)==0) {exit(2);}
    }
 
    fclose(file);
  }

  // free and write to intermediate file
  file=fopen(intermediate_file1,"w");
  if (file==NULL) {exit(1);}
  free_tree(head_p,file);
  fclose(file);

  // find clusters and get tag intensity count
  file1=fopen(intermediate_file1,"r");
  file2=fopen(intermediate_file2,"w");
  if (file1==NULL) {exit(1);}
  if (file2==NULL) {exit(1);}

  parsed_muts=parse_muts(muts);
  if (cluster(file1,file2,parsed_muts,GROUP)==0) {exit(2);}

  fclose(file1);
  fclose(file2);

  // end
  exit(0);
}


