#!/usr/bin/perl
use strict;
use warnings;
use ExtUtils::CBuilder;
use Cwd qw(abs_path);

my $compiler=$ARGV[0];
my ($obj_file,$lib_file);

##########  prepare for compilation  ##########

if (!defined $compiler)
{
#  print "No C/C++ compiler specified!\nUsing gcc as default\n";
  $compiler="gcc";
}

my $path=abs_path($0);
$path=~s/bin\/normalize\/install.pl/src/;

my $b=ExtUtils::CBuilder->new(config=>{ld=>$compiler});
unless ($b->have_compiler()) {die "Compiler doesn't exist!\n";}

#########  compile source files  ###############

open(CONFIGURE,">".$path."/configure.txt");

$obj_file=$b->compile(source=>$path."/preprocess.c");
$lib_file=$b->link_executable(objects=>$obj_file);
print CONFIGURE $lib_file." ";

#$obj_file=$b->compile(source=>$path."/inference.c");
#$lib_file=$b->link_executable(objects=>$obj_file);
$lib_file="0";
print CONFIGURE $lib_file." 1\n";

close(CONFIGURE);
