//Chrstrand structs are chained into a list, called trees
//Read structs are chained into a list hanging from each Chrstrand struct, called leaves
// the Read struct stores the information of each read 
// pos is the start of the mapping position
// len is the length of mapping
struct Read
{
  char *name,*chr,*CIGAR,*seq,*MD;
  float qual;
  char strand;
  int group,len;
  unsigned long pos;
  struct Read *smaller,*bigger;
};

// the Chrstrand struct separates tags into different groups depending on chromosome and strand. 
// len is the number of Read structs hanging from Chrstrand (duplicates are also counted)
// a len of 0 means the Chrstrand struct is not initiated yet
struct Chrstrand
{
  char *chr,strand;
  unsigned long len;
  struct Chrstrand *next;
  struct Read *read_p;
};

// The Matrix struct
// It comprises of three parts, row number (unsigned long), col number (unsigned long) and values (double float)
// A set of matrix manipulation functions are defined 
struct Matrix
{
  unsigned long row,col;
  double **values;
};

// the Cluster struct is the unit of statistical inference that represents a region of nonzero coverage in any condition
// the raw matrix is the raw total/mutant tag count coverage at a 1 bp resolution
// the binned matrix is the binned total/mutant tag count coverage at a step bp resolution
struct Cluster
{
  char *chr,strand;
  unsigned long start,end,id;
  struct Matrix *raw,*binned;
  struct Cluster *next;
};
