#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include"sam.h"
// exit 0: success
// exit 1: file handle creation problem
// exit 2: memory allocation problem
// exit 3: computation error (divided by 0, subscripts out of bounds...)
int main(int argc,char *argv[])
{
  // accept input variables
  char *intermediate_file2=argv[1];
  int GROUP=atoi(argv[2]);
  int step=atoi(argv[3]);

  // define variables
  FILE *file1;
  struct Cluster *head_p,*current_p;
  
  // read cluster
  file1=fopen(intermediate_file2,"r"); // open file
  if (file1==NULL) {exit(1);}
  head_p=get_Cluster(1,GROUP,file1,step); // read file into a list of struct Cluster
  if (head_p==NULL) {exit(2);}
  fclose(file1); // close file

  // inference
  current_p=head_p;
  do 
  {
    printf("# %lu %s %c %lu %lu\n",current_p->id,current_p->chr,current_p->strand,current_p->start,current_p->end);
    print_matrix(current_p->binned);
  } while (current_p=current_p->next);

  // terminate
  free_Cluster(head_p);// free cluster
  exit(0);
}
