// This is the structure of how the SAM file is read into memory
// Chrstrand -> Chrstrand -> Chrstrand -> Chrstrand
//   |             |           |            |
//  Read          Read        Read         Read
// |    |        |    |     |     |       |    |
//Read Read     Read Read  Read  Read    Read  Read
//         ...............

// This is the structure of how clusters are found from sorted sequencing file
// Read->bigger(Read)->bigger
//                              Read->bigger
//                                             Read->bigger(Read)->bigger(Read)->bigger 
//           ............

#define MAX_MUT 1000 // max number of mutations a read could have
#define MAX_LINE 2000 // the max number of characters in a line
#define MAX_FILE 50 // the max number of independent sequencing files

#include"definition.h" 
// the definition of the structs 
#include"misce.h"
// the definitions of miscellaneous functions
#include"order.h"  
// the definition of functions used to unqiue, order, print and free sequencing reads
#include"read.h"  
// the definition of functions used to get each sequencing read
#include"mutation.h"
// the definition of functions concerning collecting the mutation information
#include"matrix.h"
// the definition of functions used for matrix manipulation
#include"cluster.h"
// the definition of functions used to group short reads into clusters and count tag intensities
#include"initialize.h"
// the definition of functions used to initialize all data matrix before the statistical inference
