# get commmand parameters
args = commandArgs(trailingOnly = TRUE)
path = args[1]
filename = args[2]
jobid = args[3]

g1x1 = as.numeric(args[4])
g1y1 = as.numeric(args[5])
g1x2 = as.numeric(args[6])
g1y2 = as.numeric(args[7])
g1xrange = c(g1x1, g1x2)
g1yrange = c(g1y1, g1y2)

g2x1 = as.numeric(args[8])
g2y1 = as.numeric(args[9])
g2x2 = as.numeric(args[10])
g2y2 = as.numeric(args[11])
g2xrange = c(g2x1, g2x2)
g2yrange = c(g2y1, g2y2)

types = args[12:13]

setwd(path)
source(paste0("R\\library\\ssq\\", 'point.pattern.R'))

data <- read.csv(filename)[,-1]
colnames(data) <- c('x', 'y', 'group')


# compare patchs
patch.1 <- create.point.pattern(df = data, g1xrange, g1yrange, types)
patch.2 <- create.point.pattern(df = data, g2xrange, g2yrange, types)


# create output directory
dir.create("results\\", showWarnings = FALSE)
dir.create(paste0("results\\", jobid), showWarnings = FALSE)


# plot markcorr
compare.markcorr(patch.1, patch.2, paste0("results\\", jobid, "\\", "batchs.comparison.png"))
# get nearest neighbor
nn.count.1 <- find.nn(patch.1, paste0("results\\", jobid, "\\", "nn.count.region.a.csv"))
nn.count.2 <- find.nn(patch.2, paste0("results\\", jobid, "\\", "nn.count.region.b.csv"))
test.nn(nn.count.1, nn.count.2, paste0("results\\", jobid, "\\", "nn.count.p.val.txt"))
