SlideSeq.smooth.plot = function(path, file, jobid, size = 500, seed = 1234){
  set.seed(1234)
  # load libraries 
  message(c(rep("#", 40),"\n" ) )
  message("Loading packages: \n \n")
  
  if(!require(spatstat)){
    install.packages("spatstat", version = "1.61-0", repos="http://cran.us.r-project.org")
  }
  if(!require(scales)){
    install.packages("scales", version = "1.0.0", repos="http://cran.us.r-project.org")
  }
  if(!require(randomcoloR)){
    install.packages("randomcoloR", version = "1.1.0.1", repos="http://cran.us.r-project.org")
  }

  setwd(path);
  
  # load and process data 
  message(c(rep("#", 40),"\n" ) )
  message("Loading data... \n \n")
  slideseq.dat = read.table(file = file, sep = ",", header = T)
  slideseq.dat = slideseq.dat[-1, ]
  slideseq.dat = slideseq.dat[, -1]
  X = slideseq.dat
  X[, 2] = -X[, 2]
  na.idx = is.na(X[, 3])
  if(sum(na.idx)>0){
    X[, 3][na.idx] = "other"
  }
  message("Loading data finished! \n")
  
  # calculate density 
  message(c(rep("#", 40),"\n" ) )
  message("Calculating smoothed density... \n \n")
  xmin = min(X[,1])
  xmax = max(X[,1])
  ymin = min(X[,2])
  ymax = max(X[,2])
  # new range
  x.range = abs(xmin) + abs(xmax)
  y.range = abs(ymin) + abs(ymax)
  
  density.full = ppp(x = X[,1], y = X[,2], xrange = c(0, x.range), 
                     yrange = c(-y.range, 0), 
                     marks = factor(X[,3]))
  density.list = split(density.full)
  message("Smoothing finished! \n")
  
  # specify colors for generating the plots 
  total.type = length(density.list)
  all.col = hue_pal()(total.type)
  
  # generate plots 
  message(c(rep("#", 40),"\n" ) )
  message("Generating smoothed density plots... \n \n")
  cell.type = names(density.list)
  for(ii in cell.type){
    idx = which(names(density.list) == ii)
    den = density.ppp(density.list[[idx]], sigma = 200)
    dense.mat = den$v
    top.quantile = quantile(as.vector(dense.mat), 0.9)
    dense.mat[dense.mat <= top.quantile] = 0
    dense.mat[dense.mat > top.quantile]= 1
    dir.create("results\\", showWarnings = FALSE)
    dir.create(paste0("results\\", jobid), showWarnings = FALSE)
    options(device="png")
    png(file = paste0("results\\", jobid, "\\", "SmoothRegion_celltype=", ii, ".png"), 
        width = size, height = size)
    par(mar = rep(0, 4))
    par(pty="s")
    image(x = seq(from = 0, to = x.range, length.out = 128),  
          y = seq(from = -y.range, to = 0, length.out = 128),
          t(dense.mat), col = c("white", all.col[idx]), 
          yaxt='n',xaxt='n', xlab = " ", ylab = " ",
          cex.main=3, axes=FALSE
    )
    text(x = xmin+0.2*x.range, y = ymax+0.1*y.range, labels = paste0("Type: ", ii), cex = 3)
    dev.off()
    
    if(ii == cell.type[length(cell.type)]){
      # point plot #
      options(device="png")
      png(file = paste0("results\\", jobid, "\\", "Full_plot.png"), 
          width = size, height = size)
      par(mar = rep(0, 4))
      par(pty="s")
      par(bg=NA)
      image(x = seq(from = 0, to = x.range, length.out = 128),  
            y = seq(from = -y.range, to = 0, length.out = 128),
            t(dense.mat), col = c(NA), 
            yaxt='n',xaxt='n', xlab = " ", ylab = " ",
            cex.main=3, axes=FALSE
      )
      p.col = total.type 
      col.palette = distinctColorPalette(p.col)
      col.count = 1
      for(ii in cell.type){
        points(x = X[X[, 3] == ii, 1], y = X[X[, 3] == ii, 2], pch = 16,cex = 0.5,
               col = alpha(col.palette[col.count], 0.5))
        col.count = col.count + 1
      }
      dev.off()
    }
  }
  
  message("Job finished! \n")
  message(rep("#", 40) )
}
