# get commmand parameters
args = commandArgs(trailingOnly = TRUE)
path = args[1]
filename = args[2]
jobid = args[3]
x1 = as.numeric(args[4])
y1 = as.numeric(args[5])
x2 = as.numeric(args[6])
y2 = as.numeric(args[7])

xrange = c(x1, x2)
yrange = c(y1, y2)

types = args[8:length(args)]

setwd(path)
source(paste0("R\\library\\ssq\\", 'point.pattern.R'))

data <- read.csv(filename)[,-1]
colnames(data) <- c('x', 'y', 'group')

# single patch
patch <- create.point.pattern(df = data, xrange, yrange, types)

# create output directory
dir.create("results\\", showWarnings = FALSE)
dir.create(paste0("results\\", jobid), showWarnings = FALSE)

# plot markcorr
plot.markcorr.pair(patch, paste0("results\\", jobid, "\\", "markcorr.png"))
# get nearest neighbor
find.nn(patch, paste0("results\\", jobid, "\\", "nn.count.csv"))
